/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PayloadTypeRegistryImpl<B extends FriendlyByteBuf>
implements PayloadTypeRegistry<B> {
    public static final PayloadTypeRegistryImpl<FriendlyByteBuf> CONFIGURATION_C2S = new PayloadTypeRegistryImpl(ConnectionProtocol.CONFIGURATION, PacketFlow.SERVERBOUND);
    public static final PayloadTypeRegistryImpl<FriendlyByteBuf> CONFIGURATION_S2C = new PayloadTypeRegistryImpl(ConnectionProtocol.CONFIGURATION, PacketFlow.CLIENTBOUND);
    public static final PayloadTypeRegistryImpl<RegistryFriendlyByteBuf> PLAY_C2S = new PayloadTypeRegistryImpl(ConnectionProtocol.PLAY, PacketFlow.SERVERBOUND);
    public static final PayloadTypeRegistryImpl<RegistryFriendlyByteBuf> PLAY_S2C = new PayloadTypeRegistryImpl(ConnectionProtocol.PLAY, PacketFlow.CLIENTBOUND);
    private final Map<ResourceLocation, CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload>> packetTypes = new HashMap<ResourceLocation, CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload>>();
    private final ConnectionProtocol state;
    private final PacketFlow side;

    private PayloadTypeRegistryImpl(ConnectionProtocol state, PacketFlow side) {
        this.state = state;
        this.side = side;
    }

    @Override
    public <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<? super B, T> register(CustomPacketPayload.Type<T> id, StreamCodec<? super B, T> codec) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(codec, "codec");
        CustomPacketPayload.TypeAndCodec payloadType = new CustomPacketPayload.TypeAndCodec(id, codec.cast());
        if (this.packetTypes.containsKey(id.id())) {
            throw new IllegalArgumentException("Packet type " + String.valueOf(id) + " is already registered!");
        }
        this.packetTypes.put(id.id(), payloadType);
        return payloadType;
    }

    @Nullable
    public CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload> get(ResourceLocation id) {
        return this.packetTypes.get(id);
    }

    @Nullable
    public <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<B, T> get(CustomPacketPayload.Type<T> id) {
        return this.packetTypes.get(id.id());
    }

    public ConnectionProtocol getPhase() {
        return this.state;
    }

    public PacketFlow getSide() {
        return this.side;
    }
}

